<?php


include_once (GLPI_ROOT . "/inc/includes.php");
include_once(PLUGIN_TRT16_DIR . "/inc/ticket_delays.class.php");
include_once(PLUGIN_TRT16_DIR."/inc/profile.class.php");
/**
 * -------------------------------------------------------------------------
 * TRT16 plugin for GLPI
 * Copyright (C) {YEAR} by the TRT16 Development Team.
 * -------------------------------------------------------------------------
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * --------------------------------------------------------------------------
 */

/**
 * Plugin install process
 *
 * @return boolean
 */
function plugin_trt16_install()
{
    echo "instalando plugin trt16";
    global $DB;

    

    //instanciate migration with version
    $migration = new Migration(1);

    

    //Create table only if it does not exists yet!
    if (!$DB->tableExists('glpi_plugin_trt16_ticket_history')) {
        //table creation query
        $query = "CREATE TABLE glpi_plugin_trt16_ticket_history (
            tickets_id INT UNSIGNED NOT NULL,
            groups_id INT UNSIGNED NOT NULL,
            active_delay INT UNSIGNED,
            user_pending_delay INT,
            team_pending_delay INT,
            close_date DATETIME,
            N3_assignment_delay INT UNSIGNED,
            log_group INT,
            solve_group INT,
            PRIMARY KEY(tickets_id,groups_id)
            ) ENGINE=InnoDB";
        $DB->queryOrDie($query, $DB->error());
    }
    
   
    
    PluginTRT16Profile::install($migration);

    //execute the whole migration
    $migration->executeMigration();

    
   //include_once(PLUGIN_TRT16_DIR."/inc/profile.class.php");
   //PluginTRT16Profile::initProfile();
   //PluginTRT16Profile::createFirstAccess($_SESSION['glpiactiveprofile']['id']);
   

    return true;
}

/**
 * Plugin uninstall process
 *
 * @return boolean
 */
function plugin_trt16_uninstall()
{
    global $DB;

   $tables = [
      'ticket_history'
   ];

   foreach ($tables as $table) {
      $tablename = 'glpi_plugin_trt16_' . $table;
      //Create table only if it does not exists yet!
      if ($DB->tableExists($tablename)) {
         $DB->queryOrDie(
            "DROP TABLE `$tablename`",
            $DB->error()
         );
      }
   }
   return true;
}

function plugin_trt16_postinit() {
   global $CFG_GLPI, $PLUGIN_HOOKS;
   print_r($PLUGIN_HOOKS);
   foreach ($PLUGIN_HOOKS['trt16'] as $type => $typepdf) {
      CommonGLPI::registerStandardTab($type, $typepdf);
   }
}

function plugin_trt16_display_login() {
   echo Html::css(Plugin::getPhpDir('trt16', false) . "/css/styles.css");
  // echo "<div style='col-auto px-2 text-center' class='plugin_news_alert-login'>";
   echo "<div class=\"col-auto px-2 text-center\">
               
               
   <link rel=\"stylesheet\" type=\"text/css\" href=\"/marketplace/news/css/styles.css?v=366e93dca058c48eb4df7c6ae7a8582fa206ff35\" media=\"all\"><div class=\"plugin_news_alert-login\"><div class=\"plugin_news_alert-container row align-items-stretch\">
<style>
/* Mising tabler variable */
:root{
--tblr-lime: #74b816;
}
</style>
<div><br>Opções para usuários externos:</div>
<div class=\"plugin_news_alert col-xxl-8 col-xl-8 col-12\" data-id=\"1\">";
   echo '<a href="'.Plugin::getPhpDir('trt16', false) .'/front/user_signup.form.php">Criar Conta</a>';
   echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
   echo '<a href="http://glpi-hml.trt16.jus.br/front/lostpassword.php">Esqueci minha senha</a>';
   echo "</div></div>";
}

function plugin_trt16_ticket_update(Ticket $item) {
 
   $ticketId = $item->fields['id'];
   $status = $item->fields['status'];
          
 //Status = 5 é solucionado
 if($status == 5){
   $ticketDelays = new PluginTRT16TicketDelays($ticketId);
   $ticketDelays->resolveGroupsDelays();
   $ticketDelays->saveTicketDelays();
 }

 /*
  global $DB;
  $DB->queryOrDie(
      "REPLACE glpi_plugin_trt16_ticket_history 
      (tickets_id,texto) 
      VALUES (
            '9',
            '$ticketId'         
      )",
      $DB->error()
   );
   */
   
}
